#version 120
#extension GL_EXT_gpu_shader4 : enable          
			
// vertex attributes
attribute vec3 		s2_vertex;
attribute vec4		s2_texcoords; 
attribute vec3		s2_normal;
attribute vec4		s2_binormal;

uniform sampler2D 	waveHeights0;
uniform sampler2D 	waveHeights1,
					foldmap;

// TERRAIN RELATED
uniform sampler2D	heightmap;
uniform vec2		invHeightmapSize;
uniform vec3		terrainDim; // width, depth and height of the terrain
uniform vec3		invTerrainDim;
uniform float		terrainNormOrg;
uniform float		waterY;
////////////////////

uniform vec4		winds[16];
uniform float		Amplitude;
uniform float		Length;

uniform float 		tiling0;
uniform float 		tiling1;
uniform float 		tiling2;
uniform float 		tiling3;

uniform float		heightScale;
uniform float		heightScale0;
uniform float		heightScale1;
uniform float 		choppiness0;
uniform float 		choppiness1;

//uniform vec2		ofs;
uniform vec3 		campos;

varying vec2 		texcoord0;
varying vec2 		texcoord1;
varying vec2 		texcoord2;
varying vec2 		texcoord3;

varying vec4		pos;

uniform float		DeltaT;
uniform float 		wavesFoam;

varying float		coastDepth;
varying float 		waveH;
varying vec3		baseNormal;
uniform vec3		camdir;

varying vec4		wdir;
varying vec3		foamAmount;
uniform vec2		FFTwind;

//const float invWavemapSize=1.0/1024;

float Pi=3.14159265359;

float GetTerrainFlow(vec3 vertexpos)
{
	vec2 texcoord = (vertexpos.xz*invTerrainDim.xz)+vec2(0.5,0.5)+(invHeightmapSize*0.5);
	if(texcoord.x>=0.0 && texcoord.y>=0.0 && texcoord.x < 1.0 && texcoord.y < 1.0 )
		return texture2D(heightmap,texcoord).x;
	return 10000.0;
}

/*
		h00=texture2D(heightmap,texcoord.st).r;
		h10=texture2D(heightmap,texcoord.st+vec2(invHeightmapSize.x,0.0)).r;
		h01=texture2D(heightmap,texcoord.st+vec2(0.0,invHeightmapSize.y)).r;
		
		vec3 binormal3=(vec3(invHeightmapSize.x*bumpScale,0.0,h10)-vec3(0.0,0.0,h00));
		vec3 tangent3=(vec3(0.0,invHeightmapSize.y*bumpScale,h01)-vec3(0.0,0.0,h00));
		vec3 normal3=normalize(cross(binormal3,tangent3));
		normal3.y=-normal3.y;
*/

vec4 GetDirectionAndAmplitude(int i, vec3 vertexpos)
{
	float amp=0;
	float d=0;
	float disp=0;
	vec2 dir=vec2(0.0,0.0);
	
	// dist
	d=(1.0-clamp(length(vertexpos.xz - winds[i].xy)/winds[i].z,0.0,1.0));
	dir=winds[i+1].xy*d;
	amp=d;
	disp=winds[i].w;
	
	return vec4(dir,min(amp,1.0),disp);
}

					
void main()
{
	float A;
	vec2 D;
	vec2 A1;
	float L;
	float k;
	float w;
	float Q;
	float dotD;
	float C;
	float S;
			
	// snap camera pos
	vec3 cd=normalize(vec3(camdir.x,0.0,camdir.z));
	vec3 c=floor((campos+cd*6400.0)/500.0)*vec3(500.0);
	vec4 vertex=vec4(s2_vertex,1.0);
	vertex.xyz+=vec3(c.x,0.0,c.z);	
	float fade2dist=(1.0-clamp((length(vec3(campos.x,0.0,campos.z)-vec3(vertex.x,0.0,vertex.z))-20000.0)/1500.0,0.0,1.0));
	float h=heightScale*fade2dist;
	float h0=heightScale0*fade2dist;
	float h1=heightScale1*fade2dist;

	// get terrain depth
	float flow=GetTerrainFlow(vertex.xyz);
	float td=clamp(flow*0.0025,0.0,1.0);
	
	baseNormal=vec3(0.0,1.0,0.0);
	
	vec2 cTexcoords=s2_texcoords.st+c.xz/vec2(25600.0);
	texcoord0 = (cTexcoords*tiling0);
	texcoord2 = (cTexcoords*tiling2);
	texcoord1 = (cTexcoords*-tiling1);
	texcoord3 = (cTexcoords*tiling3);

	//////////////////////////////////////
	wdir=vec4(0.0,0.0,0.0,0.0);
	coastDepth=0.0;
	waveH=0.0;
	
	if(h>0.0)
	{
		//steepness=0.0;
		vec3 	P0=vec3(0.0,0.0,0.0);
		vec3	N0=vec3(0.0,1.0,0.0);
		vec4 	wave=vec4(0.0,0.0,0.0,0.0);
		
		for(int i=0; i<16; i+=2)
		{
			// get flow direction
			wave=GetDirectionAndAmplitude(i, vertex.xyz);
			wdir.xyz+=wave.xyz;
			
			if(wave.z>0.0)
			{				
				///////////////////////// WAVE 0 ////////////////////////////////////////////
				A = 100.0*wave.w;												// amplitude
				D = normalize(wave.xy);											// DIRECTION basing on wind vector
				A1=vec2(A*Amplitude);
				L = 2000.0*Length*winds[i+1].w;									// wavelength
				L=L+(1000.0*td/L)-1000.0;										// adjust wavelength basing on water depth
				k = 2200.0*Pi*winds[i+1].z/L;									// frequency
				
				w = 2.0*Pi/L;		
				Q = 1.0/(w*A1.x);
				dotD = dot(vertex.xz-winds[i].xy, D);
				C = cos(w*dotD + k*DeltaT );
				S = sin(w*dotD + k*DeltaT + 200.0);
				
				P0 += vec3(Q*A1.x*C*D.x, A1.x * S, Q*A1.y*C*D.y)*wave.z;
				N0 += vec3(-D.x*w*A1.x*C, Q*w*A1.x*S ,-D.y*w*A1.y*C)*wave.z;
			}
		}
				
		P0.y*=h;
		vertex.xyz+=P0;
		
		baseNormal = N0*fade2dist;
		baseNormal.y = 1.0-baseNormal.y;
		
		waveH=max(P0.y,0.0)*wavesFoam;
		coastDepth=1.0-td;
	}
	
	// ------------- FOAM ---------------	
	foamAmount.x=texture2D(foldmap,texcoord2.st*0.125).x*choppiness1;
	foamAmount.y=texture2D(foldmap,texcoord2.st*0.0125).x*choppiness1;//*foamMul;	
	foamAmount.z=texture2D(foldmap,texcoord0.st).y*choppiness0;//*foamMul;	
	// ----------------------------------
	
	vec3 waves=	texture2D(waveHeights0,(texcoord0.st)).xzy*vec3(choppiness0,1000.0*h0*td,-choppiness0) + 
				texture2D(waveHeights1,(texcoord2.st*0.125)).xzy*vec3(choppiness1,1000.0*h1*td,-choppiness1);
	vertex.xyz+=waves;
	
	gl_Position = gl_ModelViewProjectionMatrix*vertex;
	pos = gl_ModelViewMatrix * vertex;
}